'''
Example realscanners for sagator, version 0.1

(c) 2004-2018 Jan ONDREJ (SAL) <ondrejj(at)salstar.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
    
'''

from avlib import *
import re

__all__ = ['av_example']

class av_example(ascanner):
  '''
  av_example() realscanner can be used as template for your realscanner
  
  Usage: av_example(args...)
  '''
  
  # Define scanner name here. A realscanner's name must end with ().
  name='av_example()'

  def __init__(self, args=None):
      # This function is called from sagator's config file.
      # You can store it's parameters here, but do not make
      # other things.
      self.args = args
  def scanbuffer(self, buffer, args={}):
      # This function is called, when an scan over a buffer is required.
      # Buffer is passed as "buffer" parameter.
      # Return values:
      #   an integer - level of virus. >=1.0 means, that virus has been found
      #   an string - a simple virus name of first virus found
      #   an array - lines returned by this scanner (used in reports
      #              and for debugging

      # You need to check, if it contains a virus. For example
      # we check, if it contains an character "x".
      if b'x' in buffer:
        # now a virus (char 'x') has been found. Returning it:
        return 1.0, b'Char:x', ["Char 'x' is found!"]
      else:
        # these data are clean
        return 0.0, b'', []
      # if an error occured, you also can raise an error
      raise ScannerError('Example error')
  def scanfile(self, files, dir='', args={}):
      # This function is similiar to scanbuffer().
      # files contain an array of files returned to scan.
      # These files are in 'dir' directory.
      # You have 2 choices to scan these files. You can scan
      # files from "files" array or you can scan whole 'dir'.
      # Return values are same as in scanbuffer().
      pass
