#!/usr/bin/python3

'''dbcleanup - sagator's database cleaner

(c) 2008-2018 Jan ONDREJ (SAL) <ondrejj(at)salstar.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
'''

from __future__ import print_function

import getopt

# load config
try:
  from etc import *
except ImportError as err_str:
  if str(err_str)[-6:]=="etc":
    print("ERROR! Config file not found! Exiting now.")
    sys.exit(1)
  else:
    raise

def usage():
    '''Show help.'''
    print("dbcleanup - sagator's database cleanup script")
    print("Usage: dbcleanup.py [--logfile=...] [--debug=X]")
    print("       --logfile=...   logfile, use \"-\" for stdout")
    print("       --debug=X       debug level")
    sys.exit(0)

if __name__ == '__main__':
  debug.set_level(DEBUG_LEVEL)
  try:
    opts=['help', 'debug=', 'logfile=']
    opts,files = getopt.gnu_getopt(sys.argv[1:],'hl:',opts)
  except getopt.GetoptError as err:
    (msg,opt) = err.args
    print("Error:",msg)
    sys.exit(1)

  for key,value in opts:
    if key=="--help" or key=="-h":
      usage()
    elif key=="--debug":
      debug.set_level(int(value))
    elif key=="--logfile" or key=="-l":
      LOGFILE = value
    else:
      print("Unrecognized parameter (%s)." % ('='.join([key,value])))
      sys.exit(1)

  debug.set_logfile(LOGFILE)
  safe.ROOT_PATH=CHROOT

  # walk throught CLEANUP items
  for key, values in list(CLEANUP.items()):
    # for each scanner run cleaning
    for scanner in values:
      scanner.scanbuffer('', dict(dbc=key))
