#!/usr/bin/python3

from __future__ import print_function

import sys, re, os, pydoc

sys.path.insert(0, '../')
sys.path.insert(0, './')

import scanners, srv

HDR = '''\
== %s
==============================

'''

def extend(filename):
    try:
      return os.path.join(sys.argv[1],filename)
    except IndexError:
      return filename

class text_plain:
  def params(self,cls,filename=''):
      if filename:
        self.filename=extend(filename+'.txt')
        self.f=open(self.filename,'wt')
  def header(self,s):
      self.f.write(HDR % s)
  def help(self,name,scanner):
      self.f.write(
        '%s()\n%s\n\n' \
          % (s,re.compile(r'^', re.M).sub('|  ', pydoc.getdoc(scanner)))
      )

HTML_HDR='''\
<style type="text/css" media="all">
body {
  color: #FFFFFF;
  background-color: #112CB8;
  font-family: "Arial", "Luxi Sans", "Helvetica", sans-serif;
}
a {
        color: yellow;
        background-color: inherit;
        text-decoration: none;
}
a:visited {
        color: #FFA500;
        background-color: inherit;
        text-decoration: none;
}
a:hover {
        color: inherit;
        background-color: inherit;
        text-decoration: underline;
}
table {
  width: 100%;
  border-style: solid;
  border-width: 1px;
  border-collapse: separate;
  border-spacing: 0pt;
  border-color: white;
  margin: 6pt 0pt;
}
td {
  vertical-align: top;
  border-style: none;
  margin: 8pt;
}
td.solid {
  border-style: solid;
  border-width: 0px 0px 1px 0px;
}
pre {
  margin: 8pt;
}
.scanner {
  border-style: solid;
  border-width: 1px 0px;
  border-color: white;
}
.service {
  border-style: solid;
  border-width: 1px;
  border-color: white;
}
.other {
  border-style: solid;
  border-width: 1px;
  border-color: white;
}
</style>
'''

class text_html:
  def __init__(self):
      self.i=open(extend('Index.html'),'wt')
      self.i.write(HTML_HDR+'<table>\n')
  def __del__(self):
      self.i.write('</table>\n')
  def params(self,cls,filename=''):
      self.cls=cls
      if filename:
        self.filename='%s.html' % filename
        self.f=open(extend(self.filename),'wt')
        self.f.write(HTML_HDR)
  def header(self,s):
      self.i.write('<tr><td colspan="2" class="%s"><h2>%s</h2></td></tr>\n' \
                   % (self.cls,s))
      #self.i.write('<tr><td class="solid">NAME:</td><td class="solid">SHORT DESCRIPTION:</td></tr>\n')
      self.f.write('<h1>%s</h1>\n\n' % s)
  def help(self,name,scanner):
      doc=pydoc.getdoc(scanner)
      self.i.write(
        '<tr><td><a href="%s#%s">%s()</a></td><td>%s</td></tr>\n' \
        % (self.filename,name,name,doc.split('\n')[0])
      )
      self.f.write('<!-- NAME: %s -->\n' % name)
      self.f.write('<table border="1"><tr><td class="%s">' % self.cls)
      self.f.write('<a name="%s"><h3>%s()</h3></a>\n' % (name,name))
      self.f.write('<pre>%s</pre>\n' % doc)
      self.f.write('</td></tr></table>\n')

for writer in text_plain(),text_html():

  writer.params('scanner', 'Scanners')
  writer.header('Interscanners')
  for s in dir(scanners):
    try:
      scanner = getattr(scanners, s)
      if scanner.is_interscanner and (not scanner.is_policy_scanner):
        writer.help(s, scanner)
    except AttributeError:
      pass

  writer.params('scanner')
  writer.header('Virus scanners')
  for s in dir(scanners):
    try:
      scanner = getattr(scanners, s)
      if (not scanner.is_interscanner) and (not scanner.is_spamscan) \
         and (not scanner.is_policy_scanner):
        writer.help(s, scanner)
    except AttributeError:
      pass

  writer.params('scanner')
  writer.header('Antispam scanners')
  for s in dir(scanners):
    try:
      scanner = getattr(scanners, s)
      if (not scanner.is_interscanner) and (scanner.is_spamscan) \
         and (not scanner.is_policy_scanner):
        writer.help(s, scanner)
    except AttributeError:
      pass

  writer.params('scanner')
  writer.header('Policy scanners')
  for s in dir(scanners):
    try:
      scanner = getattr(scanners, s)
      if scanner.is_policy_scanner:
        writer.help(s, scanner)
    except AttributeError:
      pass

  writer.params('service','Services')
  writer.header('Services')
  for s in dir(srv):
    try:
      service = getattr(srv, s)
      if service.is_service:
        writer.help(s, service)
    except AttributeError:
      pass

  writer.params('other','Databases')
  writer.header('Database connections')
  for s in dir(scanners.db):
    try:
      dbc = getattr(scanners.db, s)
      if s.startswith("_"):
        # ignore python internals
        continue
      if ('dbconn'!=s) and dbc.name:
        writer.help('db.%s' % s, dbc)
    except AttributeError:
      pass

  #writer.params('other','E2I')
  #writer.header('Email to index generators')
  #for s in dir(srv):
  #  try:
  #    e2i=getattr(srv, s)
  #    if e2i.is_e2i:
  #      writer.help(s,e2i)
  #  except AttributeError:
  #    pass
