#!/usr/bin/python3

from __future__ import print_function

import sys,os
import mimetypes
from email import Encoders
from email.MIMEMultipart import MIMEMultipart
from email.MIMEBase import MIMEBase

COMMASPACE = ', '

# Create the container (outer) email message.
outer = MIMEMultipart()
outer['Subject'] = 'MIME mail '+str(sys.argv[1:])
outer['From'] = 'virtest@hostname'
outer['To'] = COMMASPACE.join(['unknown@hostname'])
outer.preamble = 'message is attached\n\n'
outer.epilogue = ''

# Assume we know that the image files are all in PNG format
for file in sys.argv[1:]:
  ctype, encoding = mimetypes.guess_type(file)
  if ctype:
    maintype, subtype = ctype.split('/', 1)
  else:
    maintype, subtype = 'binary','bin'
  fp = open(file, 'rb')
  msg = MIMEBase(maintype, subtype)
  msg.set_payload(fp.read())
  fp.close()
  Encoders.encode_base64(msg)
  msg.add_header('Content-Disposition', 'attachment', filename=file)
  outer.attach(msg)

print(outer.as_string())
