#!/usr/bin/python3

'''
Sagator Back from Quarantine script.
 
This program can be used to requeue an quarantined mail from
quarantine to queue/user mailbox.
 
(c) 2003-2020 Jan ONDREJ (SAL) <ondrejj(at)salstar.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

Usage:
  sqback [--to RCPT] quarantined_file1 [quarantined_files...]
'''

from __future__ import print_function

import sys, socket, re, os
from etc import SMTP_SERVER, CHROOT
from aglib import send_qfile, getopt, safe, tostr

def usage():
    print("sqback usage:")
    print("  sqback [--help] [--to RCPT] quarantined_file1 [quarantined_files...]")
    sys.exit(0)

if __name__ == '__main__':
  recipient=''
  try:
    opts,files=getopt.gnu_getopt(sys.argv[1:],'',['help','to='])
  except getopt.GetoptError as err:
    (msg,opt) = err.args
    print("Error:",msg)
    sys.exit(1)

  for key,value in opts:
    if key=='--help':
      usage()
    if key=='--to':
      recipient=value

  if len(files)==0:
    print("Error: No files defined!")
    usage()

  safe.ROOT_PATH=CHROOT
  try:
    for fn in files:
      sfname=safe.fn(fn)
      if os.path.isfile(sfname):
        fn=sfname
      print(tostr(send_qfile(fn, SMTP_SERVER, recipient)))
  except IOError as err:
    (ec,es) = err.args
    print("IOError:", es+":" , fn)
